<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;
use VM\ApiBundle\Entity\Company as Company;

/**
 * AllegroCategoryItem
 *
 * @ORM\Table(name="allegro_category_item")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\AllegroCategoryItemRepository")
 *
 * @ExclusionPolicy("all")
 */
class AllegroCategoryItem
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $id;

    /**
     * @var integer $item_id - id oferty
     *
     * @ORM\Column(name="item_id", type="bigint")
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $item_id;

    /**
     * @var string $name - nazwa oferty
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $name;

    /**
     * @var integer $buy_now_price - cena Kup Teraz
     *
     * @ORM\Column(name="buy_now_price", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $buy_now_price;

    /**
     * @var \DateTime $ending_time - czas zakończenia
     *
     * @ORM\Column(name="ending_time", type="datetime")
     */
    private $ending_time;

    /**
     * @var string $city - miasto w którym znajduje się towar
     *
     * @ORM\Column(name="city", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $city;

    /**
     * @var integer $state - identyfikator regionu w którym znajduje się towar
     *
     * @ORM\Column(name="state", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $state;

    /**
     * @var integer $country - identyfikator kraju w którym znajduje się towar
     *
     * @ORM\Column(name="country", type="integer")
     */
    private $country;

    /**
     * @var integer $category_id
     *
     * @ORM\Column(name="category_id", type="integer")
     */
    private $category_id;

    /**
     * @ORM\ManyToOne(targetEntity="AllegroCategory",inversedBy="items")
     * @ORM\JoinColumn(name="category_id", referencedColumnName="id")
     */
    private $category;

    /**
     * @var string $thumb_url - Odnośnik do miniaturki
     *
     * @ORM\Column(name="thumb_url", type="string", length=255)
     */
    private $thumb_url;

    /**
     * @var integer
     *
     * @ORM\Column(name="advert_service_id", type="integer", nullable=true)
     */
    private $advert_service_id;

    /**
     * @var integer $period_of_notice (month)
     *
     * @ORM\Column(name="period_of_notice", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $period_of_notice;

    /**
     * @var integer $bail surface
     *
     * @ORM\Column(name="bail", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails"})
     */
    private $bail;

    /**
     * @var float $surface
     *
     * @ORM\Column(name="surface", type="float", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $surface;

    /**
     * @ORM\ManyToOne(targetEntity="AllegroCategoryItemAdvertService",inversedBy="allegroCategoryItems")
     * @ORM\JoinColumn(name="advert_service_id", referencedColumnName="id")
     */
    private $advertService;

    /**
     * @var string $id_in_advert_service - Identyfikator oferty ogłoszeniowej, odpowiedni dla wskazanego serwisu
     *
     * @ORM\Column(name="id_in_advert_service", type="string", length=255)
     */
    private $id_in_advert_service;

    /**
     * @var integer $type_id
     *
     * @ORM\Column(name="type_id", type="integer")
     */
    private $type_id;

    /**
     * @ORM\ManyToOne(targetEntity="AllegroCategoryItemType",inversedBy="items")
     * @ORM\JoinColumn(name="type_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $type;

    /**
     * @var integer $user_id
     *
     * @ORM\Column(name="user_id", type="integer")
     */
    private $user_id;

    /**
     * @ORM\ManyToOne(targetEntity="AllegroUser",inversedBy="allegroCategoryItems")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="AllegroCategoryItemAttributes", mappedBy="item")
     */
    private $attributes;

    /**
     * @ORM\OneToMany(targetEntity="\VM\ApiBundle\Entity\CompanyAllegroCategoryItem", mappedBy="item", cascade={"persist"})
     *
     */
    protected $companyItems;
   
    /**
     * @ORM\OneToMany(targetEntity="\VM\ApiBundle\Entity\DepartmentAllegroCategoryItem", mappedBy="item")
     */
    protected $departmentItems;
   
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->attributes = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set item_id
     *
     * @param integer $itemId
     * @return AllegroCategoryItem
     */
    public function setItemId($itemId)
    {
        $this->item_id = $itemId;
    
        return $this;
    }

    /**
     * Get item_id
     *
     * @return integer 
     */
    public function getItemId()
    {
        return $this->item_id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return AllegroCategoryItem
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set buy_now_price
     *
     * @param integer $buyNowPrice
     * @return AllegroCategoryItem
     */
    public function setBuyNowPrice($buyNowPrice)
    {
        $this->buy_now_price = $buyNowPrice;
    
        return $this;
    }

    /**
     * Get buy_now_price
     *
     * @return integer 
     */
    public function getBuyNowPrice()
    {
        return $this->buy_now_price;
    }

    /**
     * Set ending_time
     *
     * @param \DateTime $endingTime
     * @return AllegroCategoryItem
     */
    public function setEndingTime($endingTime)
    {
        $this->ending_time = $endingTime;
    
        return $this;
    }

    /**
     * Get ending_time
     *
     * @return \DateTime 
     */
    public function getEndingTime()
    {
        return $this->ending_time;
    }

    /**
     * Set city
     *
     * @param string $city
     * @return AllegroCategoryItem
     */
    public function setCity($city)
    {
        $this->city = $city;
    
        return $this;
    }

    /**
     * Get city
     *
     * @return string 
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Set state
     *
     * @param integer $state
     * @return AllegroCategoryItem
     */
    public function setState($state)
    {
        $this->state = $state;
    
        return $this;
    }

    /**
     * Get state
     *
     * @return integer 
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set country
     *
     * @param integer $country
     * @return AllegroCategoryItem
     */
    public function setCountry($country)
    {
        $this->country = $country;
    
        return $this;
    }

    /**
     * Get country
     *
     * @return integer 
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * Set category_id
     *
     * @param integer $categoryId
     * @return AllegroCategoryItem
     */
    public function setCategoryId($categoryId)
    {
        $this->category_id = $categoryId;
    
        return $this;
    }

    /**
     * Get category_id
     *
     * @return integer 
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Set thumb_url
     *
     * @param string $thumbUrl
     * @return AllegroCategoryItem
     */
    public function setThumbUrl($thumbUrl)
    {
        $this->thumb_url = $thumbUrl;
    
        return $this;
    }

    /**
     * Get thumb_url
     *
     * @return string 
     */
    public function getThumbUrl()
    {
        return $this->thumb_url;
    }

    /**
     * Set advert_service_id
     *
     * @param integer $advertServiceId
     * @return AllegroCategoryItem
     */
    public function setAdvertServiceId($advertServiceId)
    {
        $this->advert_service_id = $advertServiceId;
    
        return $this;
    }

    /**
     * Get advert_service_id
     *
     * @return integer 
     */
    public function getAdvertServiceId()
    {
        return $this->advert_service_id;
    }

    /**
     * Set id_in_advert_service
     *
     * @param string $idInAdvertService
     * @return AllegroCategoryItem
     */
    public function setIdInAdvertService($idInAdvertService)
    {
        $this->id_in_advert_service = $idInAdvertService;
    
        return $this;
    }

    /**
     * Get id_in_advert_service
     *
     * @return string 
     */
    public function getIdInAdvertService()
    {
        return $this->id_in_advert_service;
    }

    /**
     * Set user_id
     *
     * @param integer $userId
     * @return AllegroCategoryItem
     */
    public function setUserId($userId)
    {
        $this->user_id = $userId;
    
        return $this;
    }

    /**
     * Get user_id
     *
     * @return integer 
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Set category
     *
     * @param \Import\ApiBundle\Entity\AllegroCategory $category
     * @return AllegroCategoryItem
     */
    public function setCategory(\Import\ApiBundle\Entity\AllegroCategory $category = null)
    {
        $this->category = $category;
    
        return $this;
    }

    /**
     * Get category
     *
     * @return \Import\ApiBundle\Entity\AllegroCategory 
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * Set advertService
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItemAdvertService $advertService
     * @return AllegroCategoryItem
     */
    public function setAdvertService(\Import\ApiBundle\Entity\AllegroCategoryItemAdvertService $advertService = null)
    {
        $this->advertService = $advertService;
    
        return $this;
    }

    /**
     * Get advertService
     *
     * @return \Import\ApiBundle\Entity\AllegroCategoryItemAdvertService 
     */
    public function getAdvertService()
    {
        return $this->advertService;
    }

    /**
     * Set user
     *
     * @param \Import\ApiBundle\Entity\AllegroUser $user
     * @return AllegroCategoryItem
     */
    public function setUser(\Import\ApiBundle\Entity\AllegroUser $user = null)
    {
        $this->user = $user;
    
        return $this;
    }

    /**
     * Get user
     *
     * @return \Import\ApiBundle\Entity\AllegroUser 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add attributes
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItemAttributes $attributes
     * @return AllegroCategoryItem
     */
    public function addAttribute(\Import\ApiBundle\Entity\AllegroCategoryItemAttributes $attributes)
    {
        $this->attributes[] = $attributes;
    
        return $this;
    }

    /**
     * Remove attributes
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItemAttributes $attributes
     */
    public function removeAttribute(\Import\ApiBundle\Entity\AllegroCategoryItemAttributes $attributes)
    {
        $this->attributes->removeElement($attributes);
    }

    /**
     * Get attributes
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Set period_of_notice
     *
     * @param integer $periodOfNotice
     * @return AllegroCategoryItem
     */
    public function setPeriodOfNotice($periodOfNotice)
    {
        $this->period_of_notice = $periodOfNotice;
    
        return $this;
    }

    /**
     * Get period_of_notice
     *
     * @return integer 
     */
    public function getPeriodOfNotice()
    {
        return $this->period_of_notice;
    }

    /**
     * Set bail
     *
     * @param integer $bail
     * @return AllegroCategoryItem
     */
    public function setBail($bail)
    {
        $this->bail = $bail;
    
        return $this;
    }

    /**
     * Get bail
     *
     * @return integer 
     */
    public function getBail()
    {
        return $this->bail;
    }

    /**
     * Set surface
     *
     * @param float $surface
     * @return AllegroCategoryItem
     */
    public function setSurface($surface)
    {
        $this->surface = $surface;
    
        return $this;
    }

    /**
     * Get surface
     *
     * @return float 
     */
    public function getSurface()
    {
        return $this->surface;
    }

    /**
     * Set type_id
     *
     * @param integer $typeId
     * @return AllegroCategoryItem
     */
    public function setTypeId($typeId)
    {
        $this->type_id = $typeId;
    
        return $this;
    }

    /**
     * Get type_id
     *
     * @return integer 
     */
    public function getTypeId()
    {
        return $this->type_id;
    }

    /**
     * Set type
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItemType $type
     * @return AllegroCategoryItem
     */
    public function setType(\Import\ApiBundle\Entity\AllegroCategoryItemType $type = null)
    {
        $this->type = $type;
    
        return $this;
    }

    /**
     * Get type
     *
     * @return \Import\ApiBundle\Entity\AllegroCategoryItemType 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set company_id
     *
     * @param integer $companyId
     * @return AllegroCategoryItem
     */
    public function setCompanyId($companyId)
    {
        $this->company_id = $companyId;
    
        return $this;
    }

    /**
     * Get company_id
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->company_id;
    }

    /**
     * Set company
     *
     * @param Company $company
     * @return AllegroCategoryItem
     */
    public function setCompany(Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return Company
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Add companyItems
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems
     * @return AllegroCategoryItem
     */
    public function addCompanyItem(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems)
    {
        $this->companyItems[] = $companyItems;
    
        return $this;
    }

    /**
     * Remove companyItems
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems
     */
    public function removeCompanyItem(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems)
    {
        $this->companyItems->removeElement($companyItems);
    }

    /**
     * Get companyItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyItems()
    {
        return $this->companyItems;
    }

    /**
     * Add departmentItems
     *
     * @param \VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $departmentItems
     * @return AllegroCategoryItem
     */
    public function addDepartmentItem(\VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $departmentItems)
    {
        $this->departmentItems[] = $departmentItems;
    
        return $this;
    }

    /**
     * Remove departmentItems
     *
     * @param \VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $departmentItems
     */
    public function removeDepartmentItem(\VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $departmentItems)
    {
        $this->departmentItems->removeElement($departmentItems);
    }

    /**
     * Get departmentItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getDepartmentItems()
    {
        return $this->departmentItems;
    }
}